#!/bin/sh


scatchan="0"

nsamps=10000000
#nskip=200000
nskip=10000000

#/pub/projects/gnuradio/GPS/OTA/mdvh_B210_dualchan/capture_GPS_L1_4MSPS_2015022301_1343_chan0_cshort.raw
#/pub/projects/gnuradio/GPS/OTA/mdvh_B210_dualchan/capture_GPS_L1_4MSPS_2015022301_1343_chan1_cshort.raw
#ref0 0 tot iets voor samplenummer 200000
#ref1 0 tot iets voor samplenummer 100000
#ref2 0 tot iets voor samplenummer 9800000
#ref3 0 tot iets voor samplenummer 380000
#ref4 0 tot iets voor samplenummer 100000
#ref5 0 tot iets voor samplenummer 320000
#
#ref channel 0 tm 5 heeft nonzero output vanaf sample 10000000
#advies skip 10M of meer
#Niet gechecked nog hoe ver de nonzero output doorloopt


nin=$(expr $nsamps + $nskip )
nmsamps=$(expr $nsamps / 1000000)
nkskip=$(expr $nskip / 1000)
nmskip=$(expr $nskip / 1000000)
nmin=$(expr $nin / 1000000)

echo "#!/bin/sh"
echo "# scatchan = ${scatchan}"
echo "# nsamps = ${nsamps} nmsamps = ${nmsamps}M"
echo "# nskip = ${nskip} nksip = ${nkskip}k nmskip = ${nmskip}M"
echo "# nin = ${nin} nmin = ${nmin}M"

cd /pub/projects/gnuradio/projects/passive_radar/eric_blossom_passive_radar/gr-passive-radar-standalone/build_rojo/src/lib/test1_rojo


scatshortsrc="capture_GPS_L1_4MSPS_2015022301_1343_chan${scatchan}_cshort.raw"
if [ ! -f "$scatshortsrc" ]
then
  echo "ln -s /pub/projects/gnuradio/GPS/OTA/mdvh_B210_dualchan/capture_GPS_L1_4MSPS_2015022301_1343_chan${scatchan}_cshort.raw ${scatshortsrc}"
fi

scatshort="scat_4MSPS_cshort_${scatchan}.raw"
if [ ! -f "$of" ]
then
  echo "ln -s ${scatshortsrc} ${scatshort}"
fi

#ln -s /pub/projects/gnuradio/GPS/OTA/mdvh_B210_dualchan/capture_GPS_L1_4MSPS_2015022301_1343_chan0_cshort.raw capture_GPS_L1_4MSPS_2015022301_1343_chan0_cshort.raw
#ln -s capture_GPS_L1_4MSPS_2015022301_1343_chan0_cshort.raw scat_4MSPS_cshort_0.raw


scatfloat="scat_4MSPS_${nmin}MS_${scatchan}_cfloat.raw"
if [ ! -f "$scatfloat" ]
then
  echo "mdvh_run_with_gr-3.6.sh ./convert_cshort_to_cfloat.py -i ${scatshort} -o ${scatfloat} -n ${nin} "
fi
# mdvh_run_with_gr-3.6.sh ./convert_cshort_to_cfloat.py -i scat_4MSPS_cshort_0.raw -o scat_4MSPS_cfloat_0.raw
# mdvh_run_with_gr-3.6.sh ./convert_cshort_to_cfloat.py -i scat_4MSPS_cshort_0.raw -o scat_4MSPS_10MS_0_cfloat.raw -n 10000000
# mdvh_run_with_gr-3.6.sh ./convert_cshort_to_cfloat.py -i scat_4MSPS_cshort_0.raw -o scat_4MSPS_100MS_0_cfloat.raw -n 100000000


scatskip="scat_4MSPS_${nmsamps}MS_skip${nkskip}k_${scatchan}_cfloat.raw"
if [ ! -f "$scatskip" ]
then
  echo "dd if=${scatfloat} bs=8 skip=${nskip} count=${nsamps} of=${scatskip}"
fi

images=""

for i in 0 1 2 3 4 5
do
  ref="ref${i}_4MSPS_cfloat.raw"
  if [ ! -f "$ref" ]
    then
      echo "ln -s /mnt/scratch_big/GPS/bigfiles/epl_tracking_ch_${i}_code_cfloat.dat ${ref}"
  fi

  refskip="ref${i}_4MSPS_${nmsamps}M_skip${nkskip}k_cfloat.raw"
  if [ ! -f "${refskip}" ]
    then
      echo "dd if=${ref} bs=8 skip=${nskip} count=${nsamps} of=${refskip}"
  fi

  xcorr="xref.gps${i}-${scatchan}_skip${nkskip}k_mdvh-xambi_M199_w4194304_d0.005_n250"
  #if [ ! -f "${xcorr}" ]
  #  then
      echo "mdvh_run_with_gr-3.6.sh ./mdvh-xambi -o ${xcorr} -M 199 -w 4194304 -d 0.005 -n 250  ${refskip} ${scatskip} "
  #fi
  img="gps${i}-${scatchan}_skip${nkskip}k_mdvh-xambi_M199_w4194304_d0.005_n250.ppm"
  #if [ ! -f "${img}" ]
  #  then
      echo "./plot_xambi_tool.m ${xcorr} ${img} "
  #fi

  images="${images} ${img}"
done
# ln -s /mnt/scratch_big/GPS/bigfiles/epl_tracking_ch_0_code_cfloat.dat ref0_4MSPS_cfloat.raw 
# ln -s /mnt/scratch_big/GPS/bigfiles/epl_tracking_ch_1_code_cfloat.dat ref1_4MSPS_cfloat.raw 
# ln -s /mnt/scratch_big/GPS/bigfiles/epl_tracking_ch_2_code_cfloat.dat ref2_4MSPS_cfloat.raw 
# ln -s /mnt/scratch_big/GPS/bigfiles/epl_tracking_ch_3_code_cfloat.dat ref3_4MSPS_cfloat.raw 
# ln -s /mnt/scratch_big/GPS/bigfiles/epl_tracking_ch_4_code_cfloat.dat ref4_4MSPS_cfloat.raw 
# ln -s /mnt/scratch_big/GPS/bigfiles/epl_tracking_ch_5_code_cfloat.dat ref5_4MSPS_cfloat.raw 
# ln -s /mnt/scratch_big/GPS/bigfiles/epl_tracking_ch_6_code_cfloat.dat ref6_4MSPS_cfloat.raw 

# dd if=ref0_4MSPS_cfloat.raw bs=8 skip=200000 count=10000000 of=ref0_4MSPS_10M_skip200k_cfloat.raw
# dd if=ref1_4MSPS_cfloat.raw bs=8 skip=200000 count=10000000 of=ref1_4MSPS_10M_skip200k_cfloat.raw


# mdvh_run_with_opt_pybombs.sh /opt/pybombs/bin/gr_plot_iq scat_4MSPS_10M_0_cfloat.raw 

echo "gimp ${images} &"




